<?php
$page_title = 'Edit Product';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';

$id = (int)($_GET['id'] ?? 0);
$product = [
  'code' => '',
  'name' => '',
  'description' => '',
  'brand' => '',
  'pack_size' => '',
  'container_type' => 'PET',
  'has_deposit' => 0,
  'price_per_case' => 0,
  'deposit_per_case' => 0,
];

if ($id) {
  $stmt = db()->prepare("SELECT * FROM products WHERE id=?");
  $stmt->bind_param('i', $id);
  $stmt->execute();
  $res = $stmt->get_result();
  if ($row = $res->fetch_assoc()) $product = $row;
  $stmt->close();
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $code = $_POST['code'] ?? '';
  $name = $_POST['name'] ?? '';
  $description = $_POST['description'] ?? '';
  $brand = $_POST['brand'] ?? '';
  $pack_size = $_POST['pack_size'] ?? '';
  $container_type = $_POST['container_type'] ?? 'PET';
  $has_deposit = isset($_POST['has_deposit']) ? 1 : 0;
  $price_per_case = (float)($_POST['price_per_case'] ?? 0);
  $deposit_per_case = (float)($_POST['deposit_per_case'] ?? 0);

  if ($id) {
    $sql = "UPDATE products SET code=?, name=?, description=?, brand=?, pack_size=?, container_type=?, has_deposit=?, price_per_case=?, deposit_per_case=? WHERE id=?";
    $stmt = db()->prepare($sql);
    $stmt->bind_param('ssssssiddi', $code,$name,$description,$brand,$pack_size,$container_type,$has_deposit,$price_per_case,$deposit_per_case,$id);
  } else {
    $sql = "INSERT INTO products (code,name,description,brand,pack_size,container_type,has_deposit,price_per_case,deposit_per_case)
            VALUES (?,?,?,?,?,?,?,?,?)";
    $stmt = db()->prepare($sql);
    $stmt->bind_param('ssssssidd', $code,$name,$description,$brand,$pack_size,$container_type,$has_deposit,$price_per_case,$deposit_per_case);
  }
  $stmt->execute();
  $stmt->close();
  redirect('index.php');
}
?>
<h4 class="mb-3"><?= $id ? 'Edit' : 'Add' ?> Product</h4>
<div class="card shadow-sm">
  <div class="card-body">
    <form method="post">
      <div class="row g-3">
        <div class="col-md-3">
          <label class="form-label">Code</label>
          <input type="text" name="code" class="form-control" value="<?= h($product['code']) ?>" required>
        </div>
        <div class="col-md-5">
          <label class="form-label">Name</label>
          <input type="text" name="name" class="form-control" value="<?= h($product['name']) ?>" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">Brand</label>
          <input type="text" name="brand" class="form-control" value="<?= h($product['brand']) ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">Description</label>
          <input type="text" name="description" class="form-control" value="<?= h($product['description']) ?>">
        </div>
        <div class="col-md-3">
          <label class="form-label">Pack Size</label>
          <input type="text" name="pack_size" class="form-control" value="<?= h($product['pack_size']) ?>" placeholder="2L x 6">
        </div>
        <div class="col-md-3">
          <label class="form-label">Container Type</label>
          <select name="container_type" class="form-select">
            <?php foreach (['PET','RGB','CAN'] as $ct): ?>
              <option value="<?= $ct ?>" <?= $product['container_type']==$ct?'selected':'' ?>><?= $ct ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label">Price per Case</label>
          <input type="number" step="0.01" name="price_per_case" class="form-control text-end" value="<?= h($product['price_per_case']) ?>">
        </div>
        <div class="col-md-3">
          <label class="form-label">Deposit per Case</label>
          <input type="number" step="0.01" name="deposit_per_case" class="form-control text-end" value="<?= h($product['deposit_per_case']) ?>">
        </div>
        <div class="col-md-3 form-check mt-4 ms-2">
          <input class="form-check-input" type="checkbox" name="has_deposit" id="hasDeposit" <?= $product['has_deposit'] ? 'checked' : '' ?>>
          <label class="form-check-label" for="hasDeposit">Has Deposit</label>
        </div>
      </div>
      <button class="btn btn-primary mt-3">Save</button>
      <a href="index.php" class="btn btn-secondary mt-3">Cancel</a>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>
