<?php
$page_title = 'Customers';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';

$res = db()->query("SELECT * FROM customers ORDER BY name");
?>
<h4 class="mb-3">Customers</h4>
<div class="card shadow-sm">
  <div class="card-body table-responsive">
    <table class="table table-sm table-striped align-middle">
      <thead>
        <tr>
          <th>Name</th>
          <th>Town</th>
          <th>Phone</th>
          <th class="text-end">Credit Limit</th>
        </tr>
      </thead>
      <tbody>
      <?php if ($res): while($c = $res->fetch_assoc()): ?>
        <tr>
          <td><?= h($c['name']) ?></td>
          <td><?= h($c['town']) ?></td>
          <td><?= h($c['phone']) ?></td>
          <td class="text-end"><?= number_format($c['credit_limit'],2) ?></td>
        </tr>
      <?php endwhile; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>
