<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/helpers.php';

if (!isset($_SESSION['van_user_id'])) redirect('index.php');

$res = db()->query("SELECT * FROM customers WHERE is_active=1 ORDER BY name");
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Route Customers</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container-fluid p-2">
  <h6 class="mb-2">Route Customers</h6>
  <div class="list-group small">
    <?php if ($res): while($c = $res->fetch_assoc()): ?>
      <a href="sale.php?customer_id=<?= (int)$c['id'] ?>" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
        <span>
          <?= h($c['name']) ?><br>
          <span class="text-muted"><?= h($c['town']) ?></span>
        </span>
        <span class="badge bg-primary rounded-pill">Sell</span>
      </a>
    <?php endwhile; endif; ?>
  </div>
</div>
</body>
</html>
