<?php
session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/helpers.php';

$error = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $email = $_POST['email'] ?? '';
    $pass  = $_POST['password'] ?? '';

    $stmt = db()->prepare("SELECT id, name, password_hash FROM users WHERE email=? AND role='VAN' AND is_active=1");
    $stmt->bind_param('s', $email);
    $stmt->execute();
    $stmt->bind_result($uid, $uname, $hash);
    if ($stmt->fetch() && password_verify($pass, $hash)) {
        $_SESSION['van_user_id'] = $uid;
        $_SESSION['van_user_name'] = $uname;
        // for now, assume van_location_id=2
        $_SESSION['van_location_id'] = 2;
        redirect('home.php');
    } else {
        $error = 'Invalid login.';
    }
    $stmt->close();
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Van Login</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark d-flex align-items-center" style="min-height:100vh;">
<div class="container">
  <div class="row justify-content-center">
    <div class="col-11 col-sm-8 col-md-5">
      <div class="card shadow">
        <div class="card-body">
          <h5 class="text-center mb-3">Van Sales – Login</h5>
          <?php if ($error): ?><div class="alert alert-danger"><?= h($error) ?></div><?php endif; ?>
          <form method="post">
            <div class="mb-2">
              <label class="form-label small">Email</label>
              <input type="email" name="email" class="form-control form-control-sm" required>
            </div>
            <div class="mb-2">
              <label class="form-label small">Password</label>
              <input type="password" name="password" class="form-control form-control-sm" required>
            </div>
            <button class="btn btn-primary w-100 btn-sm mt-2">Login</button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</body>
</html>
